% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OWSUtils.R
\docType{data}
\name{OWSUtils}
\alias{OWSUtils}
\title{OWSUtils}
\format{
\code{\link[R6]{R6Class}} object.
}
\usage{
OWSUtils
}
\value{
set of OWS Utilities
}
\description{
OWSUtils
}
\section{Static methods}{

\describe{
 \item{\code{getNamespaces()}}{
   Get the namespaces associated to a given XML object
 }
 \item{\code{findNamespace(namespaces, id, uri)}}{
   Finds a namespace by id or by URI
 }
 \item{\code{toBBOX(xmin, xmax, ymin, ymax)}}{
   Creates a bbox matrix from min/max x/y coordinates
 }
 \item{\code{findP4s(srsName, morphToESRI)}}{
   Finds the PROJ4 string definition for a given srsName
 }
 \item{\code{toCRS(srsName)}}{
  Converts a srsName into a CRS object
 }
 \item{\code{toEPSG(crs)}}{
  Get the EPSG code from a CRS object
 }
 \item{\code{getAspectRatio(bbox)}}{
  Get the aspect ratio for a given bbox
 }
}
}

\examples{
  #toBBOX
  bbox <- OWSUtils$toBBOX(-180,-90,180,90)
  
  #toCRS
  crs <- OWSUtils$toCRS("EPSG:4326")

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{OGC}
\keyword{OWS}
\keyword{Utils}
