% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSWClient.R
\docType{class}
\name{CSWClient}
\alias{CSWClient}
\title{CSWClient}
\format{\code{\link{R6Class}} object.}
\usage{
CSWClient
}
\value{
Object of \code{\link{R6Class}} with methods for interfacing an OGC
Catalogue Service for the Web.
}
\description{
CSWClient
}
\section{Methods}{

\describe{
 \item{\code{new(url, serviceVersion, user, pwd, logger)}}{
   This method is used to instantiate a CSWClient with the \code{url} of the
   OGC service. Authentication (\code{user}/\code{pwd}) is not yet supported and will
   be added with the support of service transactional modes. By default, the \code{logger}
   argument will be set to \code{NULL} (no logger). This argument accepts two possible 
   values: \code{INFO}: to print only \pkg{ows4R} logs, \code{DEBUG}: to print more verbose logs
 }
 \item{\code{getCapabilities()}}{
   Get service capabilities. Inherited from OWS Client
 }
 \item{\code{reloadCapabilities()}}{
   Reload service capabilities
 }
 \item{\code{describeRecord(namespace, ...)}}{
   Describe records. Retrieves the XML schema for CSW records. By default, returns the XML schema 
   for the CSW records (http://www.opengis.net/cat/csw/2.0.2). For other schemas, specify the
   \code{outputSchema} required, e.g. http://www.isotc211.org/2005/gmd for ISO 19115/19139 schema
 }
 \item{\code{getRecordById(id, elementSetName, ...)}}{
   Get a record by Id. By default, the record will be returned following the CSW schema 
   (http://www.opengis.net/cat/csw/2.0.2). For other schemas, specify the \code{outputSchema} 
   required,  e.g. http://www.isotc211.org/2005/gmd for ISO 19115/19139 records.
   The parameter \code{elementSetName} should among values "full", "brief", "summary". The default
   "full" corresponds to the full metadata sheet returned. "brief" and "summary" will contain only
   a subset of the metadata content.
 }
}
}

\examples{
\donttest{
   #example based on CSW endpoint responding at http://localhost:8000/csw
   csw <- CSWClient$new("http://localhost:8000/csw", serviceVersion = "2.0.2")
   
   #get capabilities
   caps <- csw$getCapabilities()
   
   #get records
   records <- csw$getRecords()
   
   #get record by id
   record <- csw$getRecordById("my-metadata-id")
   
   #Advanced examples at https://github.com/eblondel/ows4R/wiki#csw
 }

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{CSW}
\keyword{OGC}
\keyword{catalogue}
\keyword{service}
\keyword{web}
