% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osm_get_gpx_metadata.R
\name{osm_get_gpx_metadata}
\alias{osm_get_gpx_metadata}
\title{Download GPS Track Metadata}
\usage{
osm_get_gpx_metadata(gpx_id, format = c("R", "sf", "xml"))
}
\arguments{
\item{gpx_id}{A vector of track ids represented by a numeric or a character value.}

\item{format}{Format of the output. Can be \code{"R"} (default), \code{"sf"}, or \code{"xml"}.}
}
\value{
If \code{format = "R"}, returns a data frame with one trace per row. If \code{format = "sf"}, returns a \code{sf} object from
\pkg{sf}. If \code{format = "xml"}, returns a \link[xml2:oldclass]{xml2::xml_document} with the following format:

\if{html}{\out{<div class="sourceCode xml">}}\preformatted{<?xml version="1.0" encoding="UTF-8"?>
<osm version="0.6" generator="OpenStreetMap server">
  <gpx_file id="836619" name="track.gpx" lat="52.0194" lon="8.51807" uid="1234" user="Hartmut Holzgraefe" visibility="public" pending="false" timestamp="2010-10-09T09:24:19Z">
    <description>PHP upload test</description>
    <tag>test</tag>
    <tag>php</tag>
  </gpx_file>
  <gpx_file>
    ...
  </gpx_file>
</osm>
}\if{html}{\out{</div>}}
}
\description{
Use this to access the metadata about GPX files. Available without authentication if the file is marked public.
Otherwise only usable by the owner account and requires authentication.
}
\examples{
\dontrun{
trk_meta <- osm_get_gpx_metadata(gpx_id = 3498170)
trk_meta
}
}
\seealso{
Other get GPS' functions: 
\code{\link{osm_get_data_gpx}()},
\code{\link{osm_get_points_gps}()},
\code{\link{osm_list_gpxs}()}
}
\concept{get GPS' functions}
