% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_elements.R
\name{osm_redaction_object}
\alias{osm_redaction_object}
\title{Redact an object version}
\usage{
osm_redaction_object(
  osm_type = c("node", "way", "relation"),
  osm_id,
  version,
  redaction_id
)
}
\arguments{
\item{osm_type}{Object type (\code{"node"}, \code{"way"} or \code{"relation"}).}

\item{osm_id}{Object id represented by a numeric or a character value.}

\item{version}{Version of the object to redact.}

\item{redaction_id}{If missing, then this is an unredact operation. If a redaction ID was specified, then set this
element to be redacted in that redaction.}
}
\value{
Nothing is returned upon successful redaction or unredaction of an object.
}
\description{
Used by the \href{https://wiki.openstreetmap.org/wiki/Data_working_group}{Data Working Group} to hide old versions of
elements containing data privacy or copyright infringements. Only permitted for OSM accounts with the moderator role
(DWG and server admins).
}
\details{
The \code{redaction_id} is listed on \url{https://www.openstreetmap.org/redactions}. More information can be found in
\href{https://git.openstreetmap.org/rails.git/blob/HEAD:/app/controllers/redactions_controller.rb}{the source}.
}
\examples{
\dontrun{
## WARNING: this example will edit the OSM (testing) DB with your user!
# You will need a user with moderator role in the server to use `osm_redaction_object()`
set_osmapi_connection(server = "testing") # setting https://master.apis.dev.openstreetmap.org
x <- data.frame(type = "node", lat = 0, lon = 0, name = "Test redaction.")
obj <- osmapi_objects(x, tag_columns = "name")
changeset_id <- osm_create_changeset(
  comment = "Test object redaction",
  hashtags = "#testing;#osmapiR"
)

node_id <- osm_create_object(x = obj, changeset_id = changeset_id)
node_osm <- osm_get_objects(osm_type = "node", osm_id = node_id)
deleted_version <- osm_delete_object(x = node_osm, changeset_id = changeset_id)
redaction <- osm_redaction_object(
  osm_type = node_osm$type, osm_id = node_osm$id, version = 1, redaction_id = 1
)
unredaction <- osm_redaction_object(osm_type = node_osm$type, osm_id = node_osm$id, version = 1)
osm_close_changeset(changeset_id = changeset_id)
}
}
\seealso{
Other functions for moderators: 
\code{\link{osm_delete_note}()},
\code{\link{osm_hide_comment_changeset_discussion}()}
}
\concept{functions for moderators}
