% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_gps_traces.R
\name{osm_list_gpxs}
\alias{osm_list_gpxs}
\title{List user's GPX traces}
\usage{
osm_list_gpxs(format = c("R", "xml"))
}
\arguments{
\item{format}{Format of the output. Can be \code{"R"} (default) or \code{"xml"}.}
}
\value{
If \code{format = "R"}, returns a data frame with one trace per row. If \code{format = "xml"}, returns a
\link[xml2:oldclass]{xml2::xml_document} similar to \code{\link[=osm_get_gpx_metadata]{osm_get_gpx_metadata()}}. Example:

\if{html}{\out{<div class="sourceCode xml">}}\preformatted{<?xml version="1.0" encoding="UTF-8"?>
<osm version="0.6" generator="OpenStreetMap server">
	<gpx_file id="836619" name="track.gpx" lat="52.0194" lon="8.51807" uid="1234" user="Hartmut Holzgraefe" visibility="public" pending="false" timestamp="2010-10-09T09:24:19Z">
		<description>PHP upload test</description>
		<tag>test</tag>
		<tag>php</tag>
	</gpx_file>
	<gpx_file id="836620" name="track.gpx" lat="52.1194" lon="8.61807" uid="1234" user="Hartmut Holzgraefe" visibility="public" pending="false" timestamp="2010-10-09T09:27:31Z">
		<description>PHP upload test 2</description>
		<tag>test</tag>
		<tag>php</tag>
	</gpx_file>
</osm>
}\if{html}{\out{</div>}}
}
\description{
Use this to get a list of GPX traces owned by the authenticated user. Requires authentication.
}
\examples{
\dontrun{
traces <- osm_list_gpxs()
traces
}
}
\seealso{
Other get GPS' functions: 
\code{\link{osm_get_data_gpx}()},
\code{\link{osm_get_gpx_metadata}()},
\code{\link{osm_get_points_gps}()}
}
\concept{get GPS' functions}
