% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ore.ismatch}
\alias{\%~\%}
\alias{\%~~\%}
\alias{ore.ismatch}
\title{Does text match a regex?}
\usage{
ore.ismatch(regex, text, all = FALSE)

X \%~\% Y

X \%~~\% Y
}
\arguments{
\item{regex}{A single character string or object of class \code{"ore"}.}

\item{text}{A character vector of strings to search.}

\item{all}{Passed to \code{\link{ore.search}}. Makes no difference to the
return value of these functions, but influences the underlying
\code{"orematch"} object, which can be retrieved afterwards.}

\item{X}{A character vector or \code{"ore"} object. See Details.}

\item{Y}{A character vector. See Details.}
}
\value{
A logical vector, indicating whether elements of \code{text} match
  \code{regex}, or not.
}
\description{
These functions test whether the elements of a character vector match a
Oniguruma regular expression. The actual match can be retrieved using
\code{\link{ore.lastmatch}}.
}
\details{
The \code{\%~\%} infix shorthand corresponds to \code{ore.ismatch(...,
all=FALSE)}, while \code{\%~~\%} corresponds to \code{ore.ismatch(...,
all=TRUE)}. Either way, the first argument can an \code{"ore"} object, in
which case the second is the text to search, or a character vector, in
which case the second argument is assumed to contain the regex.
}
\examples{
# Test for the presence of a vowel
ore.ismatch("[aeiou]", c("sky","lake"))  # => c(FALSE,TRUE)

# The same thing, in shorter form
c("sky","lake") \%~\% "[aeiou]"

# Same again: the first argument must be an "ore" object this way around
ore("[aeiou]") \%~\% c("sky","lake")
}
\seealso{
\code{\link{ore.search}}
}

