% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfgs.R
\name{bfgs}
\alias{bfgs}
\title{Broyden-Fletcher-Goldfarb-Shanno (BFGS) Optimization}
\usage{
bfgs(
  start,
  objective,
  gradient = NULL,
  hessian = NULL,
  lower = -Inf,
  upper = Inf,
  control = list(),
  ...
)
}
\arguments{
\item{start}{Numeric vector. Starting values for the optimization parameters.}

\item{objective}{Function. The objective function to minimize.}

\item{gradient}{Function (optional). Gradient of the objective function.}

\item{hessian}{Function (optional). Hessian matrix of the objective function.}

\item{lower}{Numeric vector. Lower bounds for box constraints.}

\item{upper}{Numeric vector. Upper bounds for box constraints.}

\item{control}{List. Control parameters including convergence flags:
\itemize{
  \item \code{use_abs_f}: Logical. Use absolute change in objective for convergence.
  \item \code{use_rel_f}: Logical. Use relative change in objective for convergence.
  \item \code{use_abs_x}: Logical. Use absolute change in parameters for convergence.
  \item \code{use_rel_x}: Logical. Use relative change in parameters for convergence.
  \item \code{use_grad}: Logical. Use gradient norm for convergence.
  \item \code{use_posdef}: Logical. Verify positive definiteness at convergence.
  \item \code{use_pred_f}: Logical. Record predicted objective decrease.
  \item \code{use_pred_f_avg}: Logical. Record average predicted decrease.
  \item \code{diff_method}: String. Method for numerical differentiation.
}}

\item{...}{Additional arguments passed to objective, gradient, and Hessian functions.}
}
\value{
A list containing optimization results and iteration metadata.
}
\description{
Implements the damped BFGS Quasi-Newton algorithm with a Strong Wolfe line search 
for non-linear optimization, specifically tailored for SEM.
}
\details{
\code{bfgs} is a Quasi-Newton method that maintains an approximation of the 
inverse Hessian matrix. It is widely considered the most robust and 
efficient member of the Broyden family of optimization methods.

\bold{BFGS vs. DFP:}
While both \code{bfgs} and \code{dfp} update the inverse Hessian using 
rank-two formulas, BFGS is generally more tolerant of inaccuracies in the 
line search. This implementation uses the Sherman-Morrison formula to 
update the inverse Hessian directly, avoiding the need for matrix inversion 
at each step.

\bold{Strong Wolfe Line Search:}
To maintain the positive definiteness of the Hessian approximation and 
ensure global convergence, this algorithm employs a Strong Wolfe line search. 
This search identifies a step length \eqn{\alpha} that satisfies both sufficient 
decrease (Armijo condition) and the curvature condition.

\bold{Damping for Non-Convexity:}
In Structural Equation Modeling (SEM), objective functions often exhibit 
non-convex regions. When \code{use_damped = TRUE}, Powell's damping 
strategy is applied to the update vectors to preserve the positive 
definiteness of the Hessian approximation even when the curvature condition 
is not naturally met.
}
\references{
\itemize{
   \item Nocedal, J., & Wright, S. J. (2006). \emph{Numerical Optimization}. Springer.
   \item Fletcher, R. (1987). \emph{Practical Methods of Optimization}. Wiley.
}
}
