% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pugixml.R
\name{as_xml}
\alias{as_xml}
\title{loads character string to pugixml and returns an externalptr}
\usage{
as_xml(x, ...)
}
\arguments{
\item{x}{input as xml}

\item{...}{additional arguments passed to \code{read_xml()}}
}
\description{
loads character string to pugixml and returns an externalptr
}
\details{
might be useful for larger documents where single nodes are shortened
and otherwise the full tree has to be reimported. unsure where we have
such a case.
is useful, for printing nodes from a larger tree, that have been exported
as characters (at some point in time we have to convert the xml to R)
}
\examples{
tmp_xlsx <- tempfile()
xlsxFile <- system.file("extdata", "openxlsx2_example.xlsx", package = "openxlsx2")
unzip(xlsxFile, exdir = tmp_xlsx)

wb <- wb_load(xlsxFile)
styles_xml <- sprintf("\%s/xl/styles.xml", tmp_xlsx)

# is external pointer
sxml <- read_xml(styles_xml)

# is character
font <- xml_node(sxml, "styleSheet", "fonts", "font")

# is again external pointer
as_xml(font)
}
