% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fst.R
\name{fst}
\alias{fst}
\title{Fetch Word Style}
\usage{
fst(obnd, osn = NULL, verbose = TRUE)
}
\arguments{
\item{obnd}{onbrand report object}

\item{osn}{onbrand Word style name to fetch}

\item{verbose}{Boolean variable when set to TRUE (default) messages will be
displayed on the terminal; Messages will be included in the returned list.}
}
\value{
List with the following elements
\itemize{
\item{wsn}:    Word style name that corresponds to the specified onbrand style name (\code{osn})
\item{dff}:    Default font format for that style (the corresponding \code{md_def} section of the yaml file for that style)
\item{isgood}: Boolean variable indicating success or failure
\item{msgs}:   Vector of messages
}
}
\description{
Retrieves the style name in Word for a specified onbrand style
name.
}
\examples{
# Creating an onbrand object:
obnd = read_template(
      template = file.path(system.file(package="onbrand"), "templates", "report.docx"),
      mapping  = file.path(system.file(package="onbrand"), "templates", "report.yaml"))

# Pulling out the placeholder information:
st = fst(obnd, "Heading_3")


}
