% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classSummarisedResult.R
\name{transformToSummarisedResult}
\alias{transformToSummarisedResult}
\title{Create a <summarised_result> object from a data.frame, given a set of
specifications.}
\usage{
transformToSummarisedResult(
  x,
  group = character(),
  strata = character(),
  additional = character(),
  estimates = character(),
  settings = character()
)
}
\arguments{
\item{x}{A data.frame.}

\item{group}{Columns in x to be used in group_name-group_level formatting.}

\item{strata}{Columns in x to be used in strata_name-strata_level formatting.}

\item{additional}{Columns in x to be used in additional_name-additional_level
formatting.}

\item{estimates}{Columns in x to be formatted into:
estimate_name-estimate_type-estimate_value.}

\item{settings}{Columns in x thta form the settings of the
<summarised_result> object.}
}
\value{
A <summarised_result> object.
}
\description{
Create a <summarised_result> object from a data.frame, given a set of
specifications.
}
\examples{
x <- dplyr::tibble(
  cohort_name = c("cohort1", "cohort2"),
  variable_name = "age",
  mean = c(50, 45.3),
  median = c(55L, 44L)
)

transformToSummarisedResult(
  x = x,
  group = c("cohort_name"),
  estimates = c("mean", "median")
)

}
