% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_run_objects.R
\name{external_img}
\alias{external_img}
\title{External image}
\usage{
external_img(
  src,
  width = 0.5,
  height = 0.2,
  unit = "in",
  guess_size = FALSE,
  alt = ""
)
}
\arguments{
\item{src}{image file path}

\item{width, height}{size of the image file. It can be ignored
if parameter \code{guess_size=TRUE}, see parameter \code{guess_size}.}

\item{unit}{unit for width and height, one of "in", "cm", "mm".}

\item{guess_size}{If package 'magick' is installed, this option
can be used (set it to \code{TRUE}). The images will be read and
width and height will be guessed.}

\item{alt}{alternative text for images}
}
\description{
Wraps an image in an object that can then be embedded
in a PowerPoint slide or within a Word paragraph.

The image is added as a shape in PowerPoint (it is not possible to mix text and
images in a PowerPoint form). With a Word document, the image will be
added inside a paragraph.
}
\section{usage}{

You can use this function in conjunction with \link{fpar} to create paragraphs
consisting of differently formatted text parts. You can also use this
function as an \emph{r chunk} in an R Markdown document made with package
officedown.
}

\examples{
# wrap r logo with external_img ----
srcfile <- file.path(R.home("doc"), "html", "logo.jpg")
extimg <- external_img(
  src = srcfile, height = 1.06 / 2,
  width = 1.39 / 2
)

# pptx example ----
doc <- read_pptx()
doc <- add_slide(doc, "Title and Content")
doc <- ph_with(
  x = doc, value = extimg,
  location = ph_location_type(type = "body"),
  use_loc_size = FALSE
)
print(doc, target = tempfile(fileext = ".pptx"))

fp_t <- fp_text(font.size = 20, color = "red")
an_fpar <- fpar(extimg, ftext(" is cool!", fp_t))

# docx example ----
x <- read_docx()
x <- body_add(x, an_fpar)
print(x, target = tempfile(fileext = ".docx"))
}
\seealso{
\link{ph_with}, \link{body_add}, \link{fpar}

Other run functions for reporting: 
\code{\link{floating_external_img}()},
\code{\link{ftext}()},
\code{\link{hyperlink_ftext}()},
\code{\link{run_autonum}()},
\code{\link{run_bookmark}()},
\code{\link{run_columnbreak}()},
\code{\link{run_comment}()},
\code{\link{run_footnote}()},
\code{\link{run_footnoteref}()},
\code{\link{run_linebreak}()},
\code{\link{run_pagebreak}()},
\code{\link{run_reference}()},
\code{\link{run_tab}()},
\code{\link{run_word_field}()},
\code{\link{run_wordtext}()}
}
\concept{run functions for reporting}
