% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_fixture.R
\name{fetch_fixture}
\alias{fetch_fixture}
\alias{fetch_fixture_nrl}
\title{Return the fixture for a particular round of matches}
\usage{
fetch_fixture(
  season = NULL,
  round_number = NULL,
  comp = 111,
  source = "NRL",
  ...
)

fetch_fixture_nrl(season = NULL, round_number = NULL, comp = 111)
}
\arguments{
\item{season}{Numeric. Season year (e.g. 2025).}

\item{round_number}{Numeric. Round number (e.g. 4).}

\item{comp}{Competition id, default 111 for Telstra NRL Premiership.}

\item{source}{Source of the data ("NRL").}

\item{...}{Additional arguments passed to source-specific functions.}
}
\value{
A tibble with the fixture.
}
\description{
fetch_fixture returns the Fixture for a given NRL Round. 
Internally, it calls a fetch_fixture_* function depending on the source.

By default it uses "NRL", but can be extended later to other sources.
}
\examples{
\dontrun{
fetch_fixture(2025, 4)
fetch_fixture(2025, 18, source = "NRL")
}

}
\concept{fetch fixture functions}
