% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src_postgres.R
\name{src_postgres}
\alias{src_postgres}
\title{Setup a PostgreSQL database connection}
\usage{
src_postgres(dbname = "test", host = "localhost", port = 5432L, ...)
}
\arguments{
\item{dbname}{(character) name of database,
has to exist to open a connection}

\item{host}{(character) host of the database,
see \code{\link[RPostgres:Postgres]{RPostgres::Postgres()}}}

\item{port}{(integer) port of the database,
see \code{\link[RPostgres:Postgres]{RPostgres::Postgres()}}}

\item{...}{additional named parameters passed
on to \code{\link[RPostgres:Postgres]{RPostgres::Postgres()}}}
}
\value{
A \code{nodbi} source object
}
\description{
Setup a PostgreSQL database connection
}
\details{
Uses \pkg{RPostgres} as backend. \pkg{nodbi} creates or uses
a PostgreSQL table, with columns \verb{_id} and \code{json} created and used
by package \code{nodbi}, applying SQL functions as per
\url{https://www.postgresql.org/docs/current/functions-json.html}
to the \code{json} column.
Each row in the table represents a \code{JSON} document.
Any root-level \verb{_id} is extracted from the document(s) and used
for column \verb{_id}, otherwise a UUID is created as \verb{_id}.
The table is indexed on \verb{_id}. A custom \code{plpgsql} function
\href{https://github.com/ropensci/nodbi/blob/master/R/src_postgres.R#L60}{jsonb_merge_patch()}
is used for \code{docdb_update()}.
The order of variables in data frames returned by \code{docdb_get()}
and \code{docdb_query()} can differ from their order the input to
\code{docdb_create()}.
For a benchmark, see \url{https://github.com/ropensci/nodbi#benchmark}
}
\examples{
\dontrun{
con <- src_postgres()
print(con)
}

}
