% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{docdb_create}
\alias{docdb_create}
\title{Create documents}
\usage{
docdb_create(src, key, value, ...)
}
\arguments{
\item{src}{source object, result of call to an \link{src} function}

\item{key}{(character) A key (collection for mongo)}

\item{value}{(data.frame) A single data.frame}

\item{...}{Ignored}
}
\description{
Create documents
}
\details{
Note that with etcd, you have to prefix a key with a
forward slash.
}
\examples{
\dontrun{
# CouchDB
src <- src_couchdb()
docdb_create(src, key="mtcars2", value=mtcars)
docdb_get(src, "mtcars2")

# Elasticsearch
src <- src_elastic()
if (docdb_exists(src, "mtcars")) docdb_delete(src, "mtcars")
if (docdb_exists(src, "iris")) docdb_delete(src, "iris")
if (docdb_exists(src, "diamonds_small")) docdb_delete(src, "diamonds_small")
docdb_create(src, key = "mtcars", value = mtcars)
docdb_create(src, key = "iris", value = iris)
docdb_create(src, key = "diamonds_small", value = diamonds[1:3000L,])

# Redis
src <- src_redis()
docdb_create(src, key = "mtcars", value = mtcars)
docdb_get(src, "mtcars")
docdb_delete(src, "mtcars")

# MongoDB
src <- src_mongo(collection = "mtcars")
docdb_create(src, key = "mtcars", value = mtcars)
docdb_get(src, "mtcars")

# SQLite
src <- src_sqlite()
if (docdb_exists(src, "mtcars")) docdb_delete(src, "mtcars")
docdb_create(src, key = "mtcars", value = mtcars)
docdb_get(src, "mtcars")
if (docdb_exists(src, "contacts")) docdb_delete(src, "contacts")
## contacts is a dataset included in this package
contacts_df <- data.frame(contacts, stringsAsFactors = FALSE)
docdb_create(src, key = "contacts", value = )
docdb_get(src, "contacts")
}
}
