% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_seasons.R
\name{nhl_seasons}
\alias{nhl_seasons}
\title{Retrieve metadata on NHL seasons from the API}
\usage{
nhl_seasons(seasons = NULL)
}
\arguments{
\item{seasons}{\code{numeric()}, \code{integer()} or \code{character()},
vector of starting years of desired seasons in \code{YYYY}
format, e.g. \code{1995} or \code{"1995"} for season 1995-1996.
Accepts vectors such as \code{c(1995:2000, 2010)} to generate
multiple seasons.

Alternatively, also accepts \code{character()} with seasons in the
format \code{"YYYYZZZZ"}, where \code{ZZZZ = YYYY + 1}, e.g. \code{"19951996"}.
This is the format that ultimately gets sent to the NHL API.

Some API endpoints, notably \code{seasons} exposed via \code{\link[=nhl_seasons]{nhl_seasons()}}
also allow the value \code{"current"} to passed. This value will be
returned unchanged.}
}
\value{
\code{data.frame}, with information on seasons, one row
per year.
}
\description{
Retrieve metadata on NHL seasons from the API
}
\examples{
\dontrun{
  # Get information on all seasons
  nhl_seasons()

  # Get information on 3 historical seasons
  nhl_seasons(2015:2017)
}
}
