% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_io.R
\name{ColumnReader}
\alias{ColumnReader}
\title{Create Column Reader Object}
\usage{
ColumnReader(nrow, ncol, reader)
}
\arguments{
\item{nrow}{Integer specifying number of rows in data}

\item{ncol}{Integer specifying number of columns in data}

\item{reader}{Function that takes column indices and returns matrix}
}
\value{
An object of class \linkS4class{ColumnReader}
}
\description{
Create a new instance of the \linkS4class{ColumnReader} class for reading column-oriented data.
}
\examples{

reader_func <- function(cols) {
  matrix(rnorm(100 * length(cols)), 100, length(cols))
}
col_reader <- ColumnReader(nrow = 100L, ncol = 10L, reader = reader_func)

}
