% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VL_rolodex.R
\name{vl_rolodex}
\alias{vl_rolodex}
\title{Minimal voice leadings to all transpositions of some Tn-type mod k}
\usage{
vl_rolodex(
  source,
  goal_type = NULL,
  reorder = TRUE,
  method = c("taxicab", "euclidean", "chebyshev", "hamming"),
  edo = 12,
  rounder = 10,
  no_ties = FALSE
)
}
\arguments{
\item{source}{Numeric vector, the pitch-class set at the start of your voice leading}

\item{goal_type}{Numeric vector, any pitch-class set
representing the tn-type of your voice leading goal}

\item{reorder}{Should the results be listed from smallest to largest voice leading size?
Defaults to \code{TRUE}. If \code{FALSE} results are listed in transposition order (i.e.
\eqn{T_1}, \eqn{T_2}, ..., \eqn{T_{edo-1}}, \eqn{T_0}).}

\item{method}{What distance metric should be used? Defaults to \code{"taxicab"}
but can be \code{"euclidean"}, \code{"chebyshev"}, or \code{"hamming"}.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}

\item{no_ties}{If multiple VLs are equally small, should only one be returned? Defaults to \code{FALSE}, which
is generally what an interactive user should want.}
}
\value{
A list of length \code{edo}, each entry of which represents a voice leading (or group of
tied voice leadings). List entries are named by their transposition level.
}
\description{
Given a starting set (\code{source}) and some tn-type as a voice leading goal
(\code{goal_type}), find the minimal voice leading to every transposition
(in some mod k universe) of the goal. If a goal is not specified, the
goal is assumed to be the tn-type of the \code{source} set. This lets you see,
for example, the minimal voice leading from C7 to other dominant
seventh chords mod 12. I couldn't think of a suitably serious and clear name
for this information, so the metaphor behind "rolodex" is that these voice leadings
are the contact information that \code{source} has for all its acquaintances in \code{goal_type}.
}
\examples{
vl_rolodex(c(0, 4, 7))

vl_rolodex(c(0, 4, 7), reorder=FALSE)

#Multisets sort of work! Best resolutions from dom7 to triads with doubled root:
vl_rolodex(c(0, 4, 7, 10), c(0, 0, 4, 7))

}
