% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmult_equalities_mult.R
\name{mult_bf_equality}
\alias{mult_bf_equality}
\title{Computes Bayes Factors For Equality Constrained Multinomial Parameters}
\usage{
mult_bf_equality(x, a, p = rep(1/length(a), length(a)))
}
\arguments{
\item{x}{numeric. Vector with data}

\item{a}{numeric. Vector with concentration parameters of Dirichlet distribution. Must be the same length as \code{x}. Default sets all concentration parameters to 1}

\item{p}{numeric. A vector of probabilities of the same length as \code{x}.
Its elements must be greater than 0 and less than 1. Default is 1/K}
}
\value{
Returns a \code{data.frame} containing the Bayes factors \code{LogBFe0}, \code{BFe0}, and \code{BF0e}
}
\description{
Computes Bayes factor for equality constrained multinomial parameters
using the standard Bayesian multinomial test.
Null hypothesis \eqn{H_0} states that category proportions are exactly equal to those
specified in \code{p}.
Alternative hypothesis \eqn{H_e} states that category proportions are free to vary.
}
\details{
The model assumes that data follow a multinomial distribution and assigns a Dirichlet distribution as prior for the model parameters
(i.e., underlying category proportions). That is:
\deqn{x ~ Multinomial(N, \theta)}
\deqn{\theta ~ Dirichlet(\alpha)}
}
\examples{
data(lifestresses)
x <- lifestresses$stress.freq
a <- rep(1, nrow(lifestresses))
mult_bf_equality(x=x, a=a)
}
\references{
\insertRef{damien2001sampling}{multibridge}

\insertRef{gronau2017tutorial}{multibridge}

\insertRef{fruhwirth2004estimating}{multibridge}

\insertRef{sarafoglou2020evaluatingPreprint}{multibridge}
}
\seealso{
Other functions to evaluate informed hypotheses: 
\code{\link{binom_bf_equality}()},
\code{\link{binom_bf_inequality}()},
\code{\link{binom_bf_informed}()},
\code{\link{mult_bf_inequality}()},
\code{\link{mult_bf_informed}()}
}
\concept{functions to evaluate informed hypotheses}
