% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mudens.R
\name{mudens}
\alias{mudens}
\title{Estimate density function from right-censored survival data}
\usage{
mudens(times, delta, subset, min.time, max.time, bw.grid, bw.pilot,
bw.smooth, bw.method="local", b.cor="both", n.min.grid=51,
n.est.grid = 101, kern="epanechnikov")
}
\arguments{
\item{times}{A vector of survival times. It does not need to be sorted.}

\item{delta}{A vector indicating censoring: \code{0} - censored (alive), \code{1} - uncensored (dead).
If delta is missing, all the observations are assumed uncensored.}

\item{subset}{A logical vector indicating the observations used in analysis.
\code{TRUE} - observation is used, \code{FALSE} - observation is not used.
If missing, all the observations will be used.}

\item{min.time}{Left bound of the time domain used in analysis. If missing, \code{min.time} is set to \code{0}.}

\item{max.time}{Right bound of the time domain used in analysis.
If missing, \code{max.time} is the maximum value of times.}

\item{bw.grid}{Bandwidth grid used in the MSE minimization.
If \code{bw.method="global"} and \code{bw.grid} has one component only, no MSE minimization is performed.
The hazard estimates are computed for the value of \code{bw.grid}.
If \code{bw.grid} is missing, then a bandwidth grid of 21 components is built, having as bounds:
\code{[0.2*bw.pilot, 20*bw.pilot]}}

\item{bw.pilot}{Pilot bandwidth used in the MSE minimization.
                If missing, the default value is the one recommended by Mueller and Wang (1994):

                \code{bw.pilot = (max.time-min.time)/(8*nz^0.2)},

                 where \code{nz} is the number of uncensored observations.}

\item{bw.smooth}{Bandwidth used in smoothing the local bandwidths. Not used if

                 \code{bw.method="global"}.
                 If missing:   \code{bw.smooth=5*bw.pilot}.}

\item{bw.method}{Algorithm to be used. Possible values are: \code{"global"} - same bandwidth for all grid points.
In this case, the optimal bandwidth is obtained by minimizing the IMSE.
\code{"local"} - different bandwidths at each grid point, and the optimal bandwidth at a grid point
is obtained by minimizing the local MSE. \code{"knn"} - k nearest neighbors distance bandwidth,
and the optimal number of neighbors is obtained by minimizing the IMSE.
Note: The default value is \code{"local"}. Only the first letter needs to be given (e.g. "g", instead of \code{"global"}).}

\item{b.cor}{Boundary correction type. Possible values are:
\code{"none"} - no boundary correction, \code{"left"} - left only correction,
\code{"both"} - left and right corrections.
The default value is set to \code{"both"}. Only the first letter needs to be given (e.g. b.cor="n").}

\item{n.min.grid}{Number of points in the minimization grid. This value greatly influences the computing time. Default value is \code{51}.}

\item{n.est.grid}{Number of points in the estimation grid, where hazard estimates are computed. Default value is \code{101}.}

\item{kern}{Boundary kernel function to be used. Possible values are:
\code{"rectangle"}, \code{"epanechnikov"}, \code{"biquadratic"}, \code{"triquadratic"}.
The default value is \code{"epanechnikov"}. Only the first letter needs to be given (e.g. kern="b").}
}
\value{
Returns an object of class \code{'mudens'}, containing input and output values.
        Methods working on such an object are:
        \code{plot}, \code{lines}, \code{summary}. For a detailed description of its components,
        see \code{object.mudens} in the mudens package.
}
\description{
Estimate density function from a vector of right-censored survival times using kernel functions.
Options include three types of bandwidth functions, three types of boundary correction, and four shapes
for the kernel function. Uses the global and local bandwidth selection algorithms and the boundary kernel
formulations described in Mueller and Wang (1994). The nearest neighbor bandwidth formulation is based
on that described in Gefeller and Dette (1992). The statistical properties of many of these estimators
are reported and compared in Hess et al. The \code{mudens(.)} function is an R wrapper around C code
and returns an object of class 'mudens' based on the density estimation in the HADES program developed
by H.G. Mueller.
}
\details{
Estimate density function from a vector of right-censored survival times.

The mudens object contains a list of the input data and parameter values as well as a variety of output data.
The density function estimate is contained in the \code{haz.est} element and the corresponding time points are in \code{est.grid}.
The unsmoothed and smoothed local bandwidths are in \code{bw.loc} and \code{bw.loc.sm}, respectively.

When setting \code{bw.method='local'} or \code{'knn'}, to check the shape of the bandwidth function used in the estimation,
use \code{plot(fit$pin$min.grid, fit$bw.loc)} to plot the unsmoothed bandwidths and
use \code{lines(fit$est.grid, fit$bw.loc.sm)} to superimpose the smoothed bandwidth function.
We can also use \code{bw.smooth} to change the amount of smoothing used on the bandwidth function.

For \code{bw.method='global'}, use \code{plot(fit$bw.grid, fit$globlmse)} to check the minimization process, and
plot the estimated IMSE values over the bandwidth search grid; while for
\code{bw.method='k'}, use \code{plot(fit$k.grid, fit$k.imse)}.

You may want to repeat the search using a finer grid over a shorter interval to fine-tune the optimization or if the observed
minimum is at the extreme of the grid you should specify a different grid.
}
\examples{
time <- rexp(1000)
stat <- sample(c(0,1), 1000, 0.5)
fit <- mudens(time, stat)
summary(fit)


}
\references{
Hess, K.R. and Zhong, M. Density Function Estimation for Possibly Right-Censored Data Using Kernel Functions. Submitted.

H.G. Mueller and J.L. Wang. Hazard Rates Estimation Under Random Censoring with Varying Kernels and Bandwidths. Biometrics 50:61-76, March, 1994.

O.Gefeller and H. Dette. Nearest Neighbor Kernel Estimation of the Hazard Function From Censored Data. J. Statist. Comput. Simul., Vol.43:93-101, 1992.
}
\author{
Kenneth R. Hess
}
