% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse.kronecker.R
\name{reverse.kronecker}
\alias{reverse.kronecker}
\title{Reverses the matrices in a Kronecker product}
\usage{
reverse.kronecker(ab, p, qq)
}
\arguments{
\item{ab}{The \eqn{(NP) \times (QM)}{(NP) x (QM)} matrix \eqn{A \otimes B}.}

\item{p}{The number of rows of \eqn{A}.}

\item{qq}{The number of columns of \eqn{A}.}
}
\value{
The \eqn{(NP) \times (QM)}{(NP) x (QM)} matrix \eqn{B \otimes A}.
}
\description{
This function takes a matrix that is Kronecker product \eqn{A \otimes B}
(Definition 3.5), where \eqn{A} is \eqn{P x Q} and \eqn{B} is \eqn{N x M},
and outputs the matrix \eqn{B \otimes A}.
}
\examples{

# Create matrices
(A <- diag(1, 3))
(B <- matrix(1:6, ncol = 2))

# Perform kronecker
(kron <- kronecker(A, B))

# Perform reverse kronecker product
(reverse.kronecker(kron, 3, 3))

# Perform kronecker again
(kron2 <- kronecker(B, A))
}
\seealso{
\code{\link{kronecker}}
}
