\name{bothsidesmodel.chisquare}
\alias{bothsidesmodel.chisquare}
\title{Test subsets of \eqn{\beta} are zero}
\description{
Tests the null hypothesis that an arbitrary subset of the \eqn{\beta _{ij}}'s is zero, based on the least squares estimates, using the \eqn{\chi^2} test as in Section 7.1. The null and alternative are specified by pattern matrices \eqn{P_0} and \eqn{P_A}, respectively. If the PA is omitted, then the alternative will be taken to be the unrestricted model.
}
\usage{
bothsidesmodel.chisquare(x, y, z,pattern0,
patternA = matrix(1, nrow = ncol(x),ncol = ncol(z)))
}
\arguments{
  \item{x}{An \eqn{N x P} design matrix.}
  \item{y}{The \eqn{N x Q} matrix of observations.}
  \item{z}{A \eqn{Q x L} design matrix.}
  \item{pattern0}{An \eqn{N x P} matrix of 0's and 1's specifying the null hypothesis.}
  \item{patternA}{An optional \eqn{N x P} matrix of 0's and 1's specifying the alternative hypothesis.}
}
\value{
A list with the following components:
\item{Theta}{The vector of estimated parameters of interest.}
\item{Covtheta}{The estimated covariance matrix of the estimated parameter vector.}
\item{df}{The degrees of freedom in the test.}
\item{chisq}{\eqn{T^2} statistic in (7.4).}
\item{pvalue}{The p-value for the test.}
}
\seealso{
\code{\link{bothsidesmodel}},\code{\link{bothsidesmodel.df}},\code{\link{bothsidesmodel.hotelling}},\code{\link{bothsidesmodel.lrt}}, and \code{\link{bothsidesmodel.mle}}.
}
\examples{
#TBA
}
\keyword{bothsidesmodel}
