% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msigdbr.R
\name{msigdbr}
\alias{msigdbr}
\title{Retrieve the gene sets data frame}
\usage{
msigdbr(
  db_species = "HS",
  species = "human",
  collection = NULL,
  subcollection = NULL,
  category = deprecated(),
  subcategory = deprecated()
)
}
\arguments{
\item{db_species}{Species abbreviation for the human or mouse databases (\code{"HS"} or \code{"MM"}).}

\item{species}{Species name for output genes, such as \code{"Homo sapiens"} or \code{"Mus musculus"}. Both scientific and common names are acceptable. Use \code{msigdbr_species()} to see the available options.}

\item{collection}{Collection abbreviation, such as \code{"H"} or \code{"C1"}. Use \code{msigdbr_collections()} to see the available options.}

\item{subcollection}{Sub-collection abbreviation, such as \code{"CGP"} or \code{"BP"}. Use \code{msigdbr_collections()} for the available options.}

\item{category}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} use the \code{collection} argument}

\item{subcategory}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} use the \code{subcollection} argument}
}
\value{
A tibble (a data frame with class \code{\link[tibble:tbl_df-class]{tibble::tbl_df}}) of gene sets with one gene per row.
}
\description{
Retrieve a data frame of gene sets and their member genes.
The original human genes can be converted into their corresponding counterparts in various model organisms, including mouse, rat, pig, zebrafish, fly, and yeast.
The output includes gene symbols along with NCBI and Ensembl IDs.
}
\details{
Historically, the MSigDB resource has been tailored to the analysis of human-specific datasets, with gene sets exclusively aligned to the human genome.
Starting with release 2022.1, MSigDB incorporated a database of mouse-native gene sets and was split into human and mouse divisions ("Hs" and "Mm").
Each one is provided in the approved gene symbols of its respective species.

Mouse MSigDB includes gene sets curated from mouse-centric datasets and specified in native mouse gene identifiers, eliminating the need for ortholog mapping.
}
\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get all human gene sets
gs <- msigdbr()
head(gs)

# Get all mouse gene sets
gs <- msigdbr(db_species = "MM", species = "Mus musculus")
head(gs)

# Get CGP (chemical and genetic perturbations) gene sets with genes mapped to rat orthologs
gs <- msigdbr(species = "Rattus norvegicus", collection = "C2", subcollection = "CGP")
head(gs)
\dontshow{\}) # examplesIf}
}
\references{
\url{https://www.gsea-msigdb.org/gsea/msigdb/index.jsp}
}
