% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CnfSymbol.R
\name{CnfSymbol}
\alias{CnfSymbol}
\title{Symbols for CNF Formulas}
\usage{
CnfSymbol(universe, name, domain)
}
\arguments{
\item{universe}{(\code{\link{CnfUniverse}}) \cr
The universe in which the symbol is defined.}

\item{name}{(\code{character(1)}) \cr
The name of the symbol.}

\item{domain}{(\code{character}) \cr
The domain, i.e. the set of possible values for the symbol.
Must not be empty.}
}
\value{
A new \code{CnfSymbol} object.
}
\description{
Representation of Symbols used in CNF formulas. Symbols have a name and a
domain (a set of possible values), and are stored in a \code{\link{CnfUniverse}}.

Once created, it is currently not intended to modify or delete symbols.

Symbols can be used in CNF formulas by creating \code{\link{CnfAtom}} objects, either
by using the \verb{\%among\%} operator or by using the \code{\link[=CnfAtom]{CnfAtom()}} constructor
explicitly.

This is part of the CNF representation tooling, which is currently considered
experimental; it is for internal use.
}
\examples{
u = CnfUniverse()
X = CnfSymbol(u, "X", c("a", "b", "c"))

# Use symbols to create CnfAtom objects
X \%among\% c("a", "b")
X \%among\% "a"
X \%among\% character(0)
X \%among\% c("a", "b", "c")

}
\seealso{
Other CNF representation objects: 
\code{\link{CnfAtom}()},
\code{\link{CnfClause}()},
\code{\link{CnfFormula}()},
\code{\link{CnfUniverse}()}
}
\concept{CNF representation objects}
\keyword{internal}
