% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixedsde.sim.R
\name{mixedsde.sim}
\alias{mixedsde.sim}
\title{Simulation Of A Mixed Stochastic Differential Equation}
\usage{
mixedsde.sim(M, T, N = 100, model, random, fixed = 0, density.phi, param,
  sigma, t0 = 0, X0 = 0.01, invariant = 0, delta = T/N, op.plot = 0,
  add.plot = FALSE)
}
\arguments{
\item{M}{number of trajectories}

\item{T}{horizon of simulation.}

\item{N}{number of simulation steps, default Tx100.}

\item{model}{name of the SDE: 'OU' (Ornstein-Uhlenbeck) or 'CIR' (Cox-Ingersoll-Ross).}

\item{random}{random effects in the drift: 1 if one additive random effect, 2 if one multiplicative random effect or c(1,2) if 2 random effects.}

\item{fixed}{fixed effects in the drift: value of the fixed effect when there is only one random effect, 0 otherwise. 
If random =2, fixed can be 0 but \eqn{\beta} has to be a non negative random variable for the estimation.}

\item{density.phi}{name of the density of the random effects.}

\item{param}{vector of parameters of the distribution of the two random effects.}

\item{sigma}{diffusion parameter}

\item{t0}{time origin, default 0.}

\item{X0}{initial value of the process, default X0=0.}

\item{invariant}{1 if the initial value is simulated from the invariant distribution, default 0.01 and X0 is fixed.}

\item{delta}{time step of the simulation (T/N).}

\item{op.plot}{1 if a plot of the trajectories is required, default 0.}

\item{add.plot}{1 for add trajectories to an existing plot}
}
\value{
\item{X}{matrix (M x (N+1)) of the M trajectories. }
\item{phi}{vector (or matrix) of the M simulated random effects.}
}
\description{
Simulation of M independent trajectories of a mixed stochastic differential equation (SDE) with linear drift  and two random effects \eqn{(\alpha_j, \beta_j)}
 \eqn{dX_j(t)= (\alpha_j- \beta_j X_(t))dt + \sigma a(X_j(t)) dW_j(t)}, for \eqn{j=1, ..., M}.
}
\details{
Simulation of M independent trajectories of the SDE (the Brownian motions \eqn{Wj} are independent), with linear drift. Two diffusions are implemented, with one or two random effects:
\subsection{Ornstein-Uhlenbeck model (OU)}{
If random = 1, \eqn{\beta} is a fixed effect: \eqn{dX_j(t)= (\alpha_j- \beta X_j(t))dt + \sigma dW_j(t)  } 

If random = 2, \eqn{\alpha} is a fixed effect: \eqn{dX_j(t)= (\alpha - \beta_j X_j(t))dt + \sigma dW_j(t)  }

If random = c(1,2), \eqn{dX_j(t)= (\alpha_j- \beta_j X_j(t))dt + \sigma dW_j(t)  } 
}
\subsection{Cox-Ingersoll-Ross model (CIR)}{
If random = 1, \eqn{\beta} is a fixed effect: \eqn{dX_j(t)= (\alpha_j- \beta X_j(t))dt + \sigma \sqrt{X_j(t)} dW_j(t)  } 

If random = 2, \eqn{\alpha} is a fixed effect: \eqn{dX_j(t)= (\alpha - \beta_j X_j(t))dt + \sigma \sqrt{X_j(t)} dW_j(t)  } 

If random = c(1,2), \eqn{dX_j(t)= (\alpha_j- \beta_j X_j(t))dt + \sigma \sqrt{X_j(t)}  dW_j(t)  } 
}
The initial value of each trajectory can be simulated from the invariant distribution of the process:
 Normal distribution with mean \eqn{\alpha/\beta} and variance \eqn{\sigma^2/(2 \beta)} for the OU,  a gamma distribution
 \eqn{\Gamma(2\alpha/\sigma^2,  \sigma^2/(2\beta))} for the C-I-R model.

\subsection{Density of the random effects}{
Several densities are implemented for the random effects, depending on the number of random effects. 

\emph{If two random effects, choice between} 

'normalnormal': Normal distributions for both  \eqn{\alpha} \eqn{\beta} and param=c(mean_\eqn{\alpha}, sd_\eqn{\alpha}, mean_\eqn{\beta}, sd_\eqn{\beta})

'gammagamma': Gamma distributions for both  \eqn{\alpha} \eqn{\beta} and param=c(shape_\eqn{\alpha}, scale_\eqn{\alpha}, shape_\eqn{\beta}, scale_\eqn{\beta})

'gammainvgamma': Gamma for \eqn{\alpha}, Inverse Gamma for \eqn{\beta} and param=c(shape_\eqn{\alpha}, scale_\eqn{\alpha}, shape_\eqn{\beta}, scale_\eqn{\beta})

'normalgamma':  Normal for \eqn{\alpha}, Gamma for \eqn{\beta} and param=c(mean_\eqn{\alpha}, sd_\eqn{\alpha}, shape_\eqn{\beta}, scale_\eqn{\beta})

'normalinvgamma':  Normal for \eqn{\alpha}, Inverse Gamma for \eqn{\beta} and param=c(mean_\eqn{\alpha}, sd_\eqn{\alpha}, shape_\eqn{\beta}, scale_\eqn{\beta})

'gammagamma2':  Gamma \eqn{+2 * \sigma^2} for \eqn{\alpha},  Gamma \eqn{+ 1} for \eqn{\beta}  and param=c(shape_\eqn{\alpha}, scale_\eqn{\alpha}, shape_\eqn{\beta}, scale_\eqn{\beta})

'gammainvgamma2':   Gamma \eqn{+2 * \sigma^2} for \eqn{\alpha}, Inverse Gamma for \eqn{\beta} and param=c(shape_\eqn{\alpha}, scale_\eqn{\alpha}, shape_\eqn{\beta}, scale_\eqn{\beta})

\emph{If only \eqn{\alpha} is random, choice between}

'normal': Normal distribution with param=c(mean, sd)

lognormal': logNormal distribution with param=c(mean, sd)

'mixture.normal': mixture of normal distributions \eqn{p N(\mu1,\sigma1^2) + (1-p)N(\mu2, \sigma2^2)} with 
param=c(p, \eqn{\mu1, \sigma1, \mu2, \sigma2})

'gamma': Gamma distribution with param=c(shape, scale) 

'mixture.gamma': mixture of Gamma distribution \eqn{p \Gamma(shape1,scale1) + (1-p)\Gamma(shape2,scale2)}
with param=c(p, shape1, scale1, shape2, scale2)

'gamma2': Gamma distribution \eqn{+2 * \sigma^2} with param=c(shape, scale) 

'mixed.gamma2': mixture of Gamma distribution \eqn{p \Gamma(shape1,scale1) + (1-p) \Gamma(shape2,scale2)} + \eqn{+2 * \sigma^2}
with param=c(p, shape1, scale1, shape2, scale2)

\emph{If only \eqn{\beta} is random, choice between}
 'normal': Normal distribution with param=c(mean, sd)
 
 'gamma': Gamma distribution with param=c(shape, scale) 
 
 'mixture.gamma': mixture of Gamma distribution \eqn{p \Gamma(shape1,scale1) + (1-p) \Gamma(shape2,scale2)}
with param=c(p, shape1, scale1, shape2, scale2)

}
}
\examples{
#Simulation of 5 trajectories of the OU SDE with random =1, and a Gamma distribution.

simuOU <- mixedsde.sim(M=5, T=10,N=1000,model='OU', random=1,fixed=0.5,
density.phi='gamma', param=c(1.8, 0.8) , sigma=0.1,op.plot=1)
X <- simuOU$X ; 
phi <- simuOU$phi
hist(phi)
}
\references{
This function mixedsde.sim is based on the package sde, function sde.sim. See Simulation and Inference for stochastic differential equation, S.Iacus, \emph{Springer Series in Statistics 2008}
Chapter 2
}
\seealso{
\url{https://cran.r-project.org/package=sde}
}
