% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blimp.print.R
\name{blimp.print}
\alias{blimp.print}
\title{Print Blimp Output}
\usage{
blimp.print(x,
            result = c("all", "default", "algo.options", "data.info",
            "model.info", "warn.mess", "error.mess", "out.model", "gen.param"),
            exclude = NULL, color = c("none", "blue", "green"),
            style = c("bold", "regular"), not.result = TRUE,
            write = NULL, append = TRUE, check = TRUE, output = TRUE)
}
\arguments{
\item{x}{a character string indicating the name of the Blimp output
file with or without the file extension \code{.blimp-out},
e.g., \code{"Blimp_Output.blimp-out"} or \code{"Blimp_Output"}.
Alternatively, a \code{misty.object} of type \code{blimp}
can be specified, i.e., result object of the \code{blimp.print()}
function.}

\item{result}{a character vector specifying Blimp result sections included
in the output (see 'Details').}

\item{exclude}{a character vector specifying Blimp input command or result
sections excluded from the output (see 'Details').}

\item{color}{a character vector with two elements indicating the colors
used for the main headers (e.g., \code{"ALGORITHMIC OPTIONS SPECIFIED:"}),
and for the headers \code{Outcome Variable:} and
\code{Missing predictor:}, \code{Latent Variable:},
and \code{Covariance Matrix:}.}

\item{style}{a character vector with two elements indicating the style
used for headers (e.g., \code{"ALGORITHMIC OPTIONS SPECIFIED:"}),
and for the main headers (e.g., \code{"ALGORITHMIC OPTIONS SPECIFIED:"}),
and for the headers \code{Outcome Variable:} and
\code{Missing predictor:}, \code{Complete variable:}, \code{Latent Variable:},
and \code{Covariance Matrix:}.}

\item{not.result}{logical: if \code{TRUE} (default), character vector indicating
the result sections not requested are shown on the console.}

\item{write}{a character string naming a file for writing the output into
a text file with file extension \code{".txt"} (e.g.,
\code{"Output.txt"}).}

\item{append}{logical: if \code{TRUE} (default), output will be appended
to an existing text file with extension \code{.txt} specified
in \code{write}, if \code{FALSE} existing text file will be
overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification
is checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown on the
console.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:

\item{\code{call}}{function call}
\item{\code{type}}{type of analysis}
\item{\code{x}}{character string or misty object}
\item{\code{args}}{specification of function arguments}
\item{\code{print}}{print objects}
\item{\code{notprint}}{character vectors indicating the result sections not requested}
\item{\code{result}}{list with Blimp version (\code{blimp}) and result sections
                     (\code{result})}
}
\description{
This function prints the result sections of a Blimp output file (\code{.blimp-out})
on the R console. By default, the function prints selected result sections,
i.e., \code{Algorithmic Options Specified}, \code{Data Information},
\code{Model Information}, \code{Warning Messages}, \code{Outcome Model Estimates},
and \code{Generated Parameters}.
}
\details{
\describe{
\item{\strong{Result Sections}}{Following result sections can be selected by
using the \code{result} argument or excluded by using the \code{exclude}
argument:
   \itemize{
      \item{\code{"algo.options"}} for the \code{ALGORITHMIC OPTIONS SPECIFIED} section
      \item{\code{"simdat.summary"}} for the \code{SIMULATED DATA SUMMARIES} section
      \item{\code{"order.simdat"}} for the \code{VARIABLE ORDER IN SIMULATED DATA} section
      \item{\code{"burnin.psr"}} for the \code{BURN-IN POTENTIAL SCALE REDUCTION (PSR) OUTPUT} section
      \item{\code{"mh.accept"}} for the \code{METROPOLIS-HASTINGS ACCEPTANCE RATES} section
      \item{\code{"data.info"}} for the \code{DATA INFORMATION} section
      \item{\code{"var.imp"}} for the \code{VARIABLES IN IMPUTATION MODEL} section
      \item{\code{"model.info"}} for the \code{MODEL INFORMATION} section
      \item{\code{"param.label"}} for the \code{PARAMETER LABELS} section
      \item{\code{"warn.mess"}} for the \code{WARNING MESSAGES} section
      \item{\code{"fit"}} for the \code{MODEL FIT} section
      \item{\code{"cor.resid"}} for the \code{CORRELATIONS AMONG RESIDUALS} section
      \item{\code{"out.model"}} for the \code{OUTCOME MODEL ESTIMATES} section
      \item{\code{"pred.model"}} for the \code{PREDICTOR MODEL ESTIMATES} section
      \item{\code{"gen.param"}} for the \code{GENERATED PARAMETERS} section
      \item{\code{"order.impdat"}} for the \code{VARIABLE ORDER IN IMPUTED DATA} section
   }
Note that all result sections are requested by specifying \code{result = "all"}.
The \code{result} argument is also used to select one (e.g., \code{result = "algo.options"})
or more than one result sections (e.g., \code{result = c("algo.options", "fit")}),
or to request result sections in addition to the default setting (e.g.,
\code{result = c("default", "fit")}). The \code{exclude} argument is used
to exclude result sections from the output (e.g., \code{exclude = "algo.options"}).
}
}
}
\examples{
\dontrun{

#----------------------------------------------------------------------------
# Blimp Example 4.3: Linear Regression

# Example 1a: Default setting
blimp.print("Ex4.3.blimp-out")

# Example 1c: Print OUTCOME MODEL ESTIMATES only
blimp.print("Ex4.3.blimp-out", result = "out.model")

# Example 1d: Print MODEL FIT in addition to the default setting
blimp.print("Ex4.3.blimp-out", result = c("default", "fit"))

# Example 1e: Exclude DATA INFORMATION section
blimp.print("Ex4.3.blimp-out", exclude = "data.info")

# Example 1f: Print all result sections, but exclude MODEL FIT section
blimp.print("Ex4.3.blimp-out", result = "all", exclude = "fit")

# Example 1g: Print result section in a different order
blimp.print("Ex4.3.blimp-out", result = c("model.info", "fit", "algo.options"))

#----------------------------------------------------------------------------
# misty.object of type 'blimp.print'

# Example 2
# Create misty.object
object <- blimp.print("Ex4.3.blimp-out", output = FALSE)

# Print misty.object
blimp.print(object)

#----------------------------------------------------------------------------
# Write Results

# Example 3: Write Results into a text file
blimp.print("Ex4.3.blimp-out", write = "Output_4-3.txt")
}
}
\references{
Keller, B. T., & Enders, C. K. (2023). \emph{Blimp user’s guide} (Version 3).
Retrieved from www.appliedmissingdata.com/blimp
}
\seealso{
\code{\link{blimp}}, \code{\link{blimp.update}}, \code{\link{blimp.run}}, \code{\link{blimp.plot}}, \code{\link{blimp.bayes}}
}
\author{
Takuya Yanagida
}
