% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_functions.R
\name{midas_estimate}
\alias{midas_estimate}
\title{MIDAS regression estimation function}
\usage{
midas_estimate(
  est.y,
  est.x,
  est.lag.y,
  est.xdate,
  polynomial,
  loss,
  num.evals,
  num.coef,
  startx_all = NULL,
  seed = NULL,
  ...
)
}
\arguments{
\item{est.y}{response variable.}

\item{est.x}{predictor variable lags in MIDAS data format.}

\item{est.lag.y}{autoregressive lags of response variable (if NULL DL-MIDAS model is estimated).}

\item{est.xdate}{predictor variable lag dates in MIDAS data format.}

\item{polynomial}{MIDAS lag polynomial specification.}

\item{loss}{loss function.}

\item{num.evals}{number of objective function evaluations using random starting parameter values.}

\item{num.coef}{number of best coefficients to use as starting values in nonlinear optimization.}

\item{startx_all}{starting values to feed into optimization algorithm.}

\item{seed}{value used in set.seed for randomly drawing initial starting values.}

\item{...}{optional parameters to feed into other functions.}
}
\value{
returns estimates of coefficient vector for a desired model specification.
}
\description{
Estimates a single variate MIDAS model.
}
\details{
For specficiation details, \code{midas_dl} or \code{midas_ardl} function descriptions for more details.
}
\author{
Jonas Striaukas
}
\keyword{internal}
