% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineGrowthLimFuncDefault.R
\name{combineGrowthLimFuncDefault}
\alias{combineGrowthLimFunc}
\alias{combineGrowthLimFuncDefault}
\title{combines the growth limitation functions and max growth rates to get the growth rate of strain}
\usage{
combineGrowthLimFuncDefault(strainName, groupName, pathName, subst, ess, boost,
  bio.sub, maxGrowthRate, growthLim, keyResName, nonBoostFrac)
}
\arguments{
\item{strainName}{Name of the strain that is being looped through in the ODE solver}

\item{groupName}{Name of microbial group that is being looped through in the ODE solver}

\item{pathName}{Name of metabolic path (e.g. path1) that is being looped through in the ODE solver}

\item{subst}{Vector of strings giving the names of the substitutable resources  for given strain, pathway}

\item{ess}{Vector of strings giving the names of the essential resources  for given strain, pathway}

\item{boost}{Vector of strings giving the names of the boosting resources  for given strain, pathway}

\item{bio.sub}{Vector of strings giving the names of the microbial resources  for given strain, pathway}

\item{maxGrowthRate}{Vector containing maximum growth rate on each resource (named by resourceNames). If a resource is not on the pathway the value is NA}

\item{growthLim}{Vector containing the growth limitation from each resource (named by resourceNames). If a resource is not on the pathway the value is NA}

\item{keyResName}{String giving the name of the key resource on this pathway}

\item{nonBoostFrac}{(scalar) Fraction of max growth achievable if boosting resource is not present but is required on this pathway}
}
\value{
(scalar) specific growth rate in units of inverse time
}
\description{
Returns the specific growth rate in units of inverse time
}

