% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymcoef.R
\name{xasym}
\alias{xasym}
\title{Coefficient of extremal asymmetry}
\usage{
xasym(
  data,
  u = NULL,
  nq = 40,
  qlim = c(0.8, 0.99),
  method = c("empirical", "emplik"),
  confint = c("none", "wald", "bootstrap"),
  level = 0.95,
  B = 999L,
  ties.method = "random",
  plot = TRUE,
  ...
)
}
\arguments{
\item{data}{an \code{n} by 2 matrix of observations}

\item{u}{vector of probability levels at which to evaluate extremal asymmetry}

\item{nq}{integer; number of quantiles at which to evaluate the coefficient if \code{u} is \code{NULL}}

\item{qlim}{a vector of length 2 with the probability limits for the quantiles}

\item{method}{string indicating the estimation method, one of \code{empirical} or empirical likelihood (\code{emplik})}

\item{confint}{string for the method used to derive confidence intervals, either \code{none} (default) or a nonparametric \code{bootstrap}}

\item{level}{probability level for confidence intervals, default to 0.95 or bounds for the interval}

\item{B}{integer; number of bootstrap replicates (if applicable)}

\item{ties.method}{string; method for handling ties. See the documentation of \link[base]{rank} for available options.}

\item{plot}{logical; if \code{TRUE}, return a plot.}

\item{...}{additional parameters for plots}
}
\value{
an invisible data frame with columns
\describe{
\item{\code{threshold}}{vector of thresholds on the probability scale}
\item{\code{coef}}{extremal asymmetry coefficient estimates}
\item{\code{confint}}{either \code{NULL} or a matrix with two columns containing the lower and upper bounds for each threshold}
}
}
\description{
This function implements estimators of the bivariate
 coefficient of extremal asymmetry proposed in
 Semadeni's (2021) PhD thesis.
 Two estimators are implemented: one based on empirical distributions, the second using empirical likelihood.
}
\details{
Let \code{U}, \code{V} be uniform random variables and define the partial extremal dependence coefficients
\eqn{\varphi_{+}(u) = \Pr(V > U | U > u, V > u)},
\eqn{\varphi_{-}(u) = \Pr(V < U | U > u, V > u)} and
\eqn{\varphi_0(u) = \Pr(V = U | U > u, V > u)}
Define
\deqn{ \varphi(u) = \frac{\varphi_{+} - \varphi_{-}}{\varphi_{+} + \varphi_{-}}}

The empirical likelihood estimator, derived for max-stable vectors with unit Frechet margins, is
\deqn{\frac{\sum_i p_i I(w_i \leq 0.5) - 0.5}{0.5 - 2\sum_i p_i(0.5-w_i) I(w_i \leq 0.5)}}
where \eqn{p_i} is the empirical likelihood weight for observation \eqn{i} and \eqn{w_i} is the pseudo-angle associated to the first coordinate.
}
\examples{
\dontrun{
samp <- rmev(n = 1000,
             d = 2,
             param = 0.2,
             model = "log")
xasym(samp, confint = "wald")
xasym(samp, method = "emplik")
}
}
\references{
Semadeni, C. (2020). Inference on the Angular Distribution of Extremes, PhD thesis, EPFL, no. 8168.
}
