% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readingandfes.R
\name{read.hills3d}
\alias{read.hills3d}
\title{Read 3D HILLS from Plumed}
\usage{
read.hills3d(file = "HILLS", per = c(FALSE, FALSE, FALSE),
  pcv1 = c(-pi, pi), pcv2 = c(-pi, pi), pcv3 = c(-pi, pi),
  ignoretime = FALSE)
}
\arguments{
\item{file}{HILLS file from Plumed.}

\item{per}{logical vector specifying periodicity of collective variables.}

\item{pcv1}{periodicity of CV1.}

\item{pcv2}{periodicity of CV2.}

\item{pcv3}{periodicity of CV3.}

\item{ignoretime}{time in the first column of the HILLS file will be ignored.}
}
\value{
hillsfile object.
}
\description{
`read.hills3d` reads a HILLS file generated by Plumed and returns a hillsfile3d object.
User can specify whether some collective variables are periodic.
}
\examples{
l1<-"1 -1.587 -2.969  3.013 0.3 0.3 0.3 1.111 10"
l2<-"2 -1.067  2.745  2.944 0.3 0.3 0.3 1.109 10"
l3<-"3 -1.376  2.697  3.049 0.3 0.3 0.3 1.080 10"
l4<-"4 -1.663  2.922 -3.065 0.3 0.3 0.3 1.072 10"
fourhills<-c(l1,l2,l3,l4)
tf <- tempfile()
writeLines(fourhills, tf)
read.hills3d(tf, per=c(TRUE,TRUE))
}
