% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_elixhauser_index_scores.R
\name{get_elixhauser_index_scores}
\alias{get_elixhauser_index_scores}
\title{Get Elixhauser Index Scores}
\usage{
get_elixhauser_index_scores()
}
\value{
A \code{data.frame} with the following columns:
\itemize{
\item \code{condition}: Character vector of the conditions
\item \code{index}: Character vector indicating if the score is for the mortality or the readmission index score
\item \verb{elixhauser_<variant>}: integer vector of the scores
}
}
\description{
Functions to get a copy of internal lookup tables for the ICD codes and index
scores used in assessing Elixhauser comorbidities.
}
\examples{
head(get_elixhauser_index_scores())
str(get_elixhauser_index_scores())

}
\seealso{
\itemize{
\item \code{\link[=get_elixhauser_codes]{get_elixhauser_codes()}} for the lookup table of ICD codes mapping to the
Elixhauser comorbidities.
\item \code{\link[=get_elixhauser_poa]{get_elixhauser_poa()}} for the lookup table of the conditions which do an
do not require associated ICD codes to be present-on-admission to flag the
comorbidity.
\item \code{\link[=comorbidities]{comorbidities()}} for applying comorbidity algorithms to a data set.
}
}
