% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measrfit-class.R
\docType{class}
\name{measrfit-class}
\alias{measrfit-class}
\alias{measrfit}
\title{Class \code{measrfit} of models fitted with the \strong{measr} package}
\description{
Models fitted with the \strong{measr} package are represented as a \code{measrfit}
object, which contains the posterior draws, Stan code, priors, and other
relevant information.
}
\section{Slots}{

\describe{
\item{\code{data}}{The data and Q-matrix used to estimate the model.}

\item{\code{type}}{The type of DCM that was estimated.}

\item{\code{prior}}{A \link[=measrprior]{measrprior} object containing information on the
priors used in the model.}

\item{\code{stancode}}{The model code in \strong{Stan} language.}

\item{\code{method}}{The method used to fit the model.}

\item{\code{algorithm}}{The name of the algorithm used to fit the model.}

\item{\code{backend}}{The name of the backend used to fit the model.}

\item{\code{model}}{The fitted Stan model. This will object of class
\link[rstan:stanfit-class]{rstan::stanfit} if \code{backend = "rstan"} and
\href{https://mc-stan.org/cmdstanr/reference/CmdStanMCMC.html}{\code{CmdStanMCMC}}
if \code{backend = "cmdstanr"} was specified when fitting the model.}

\item{\code{respondent_estimates}}{An empty list for adding estimated person
parameters after fitting the model.}

\item{\code{fit}}{An empty list for adding model fit information after fitting the
model.}

\item{\code{criteria}}{An empty list for adding information criteria after fitting
the model.}

\item{\code{reliability}}{An empty list for adding reliability information after
fitting the model.}

\item{\code{file}}{Optional name of a file which the model objects was saved to
or loaded from.}

\item{\code{version}}{The versions of \strong{measr}, \strong{Stan}, \strong{rstan} and/or
\strong{cmdstanr} that were used to fit the model.}
}}

\seealso{
\code{\link[=measr_dcm]{measr_dcm()}}
}
