% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statusPartition.R
\name{statusPartition}
\alias{statusPartition}
\title{Stratified Partition}
\usage{
statusPartition(y, times, p = 0.8, ...)
}
\arguments{
\item{y}{response \eqn{y},
a \link[survival]{Surv} object}

\item{times}{positive \link[base]{integer} scalar \eqn{n},
number of \link[base]{replicate}s of partitions. Default \code{1L}.}

\item{p}{\link[base]{double} scalar between 0 and 1,
percentage \eqn{p} of training subjects, default \code{.8}}

\item{...}{additional parameters, currently not in use}
}
\value{
Function \code{\link[=statusPartition]{statusPartition()}} returns a length-\eqn{n} \link[stats]{listof}
\link[base]{integer} \link[base]{vector}s.
In each \link[base]{integer} \link[base]{vector} indicates the training subjects.
}
\description{
A variation of \link[caret]{createDataPartition},
to split \link[survival]{Surv} \eqn{y} by survival status
instead of the percentiles survival time.
}
\details{
See \code{vignette('intro', package = 'maxEff')}.
}
\note{
Function \code{caTools::sample.split} is not what we need.
}
\keyword{internal}
