% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baskin_robbins.R
\name{create_1D_mapper_object}
\alias{create_1D_mapper_object}
\title{One-Dimensional Mapper}
\usage{
create_1D_mapper_object(
  data,
  dists,
  filtered_data,
  cover,
  clusterer = global_hierarchical_clusterer("single", dists)
)
}
\arguments{
\item{data}{A data frame.}

\item{dists}{A distance matrix associated to the data frame. Can be a \code{dist} object or \code{matrix}.}

\item{filtered_data}{The result of a function applied to the data frame; there should be one filter value per observation in the original data frame.
These values need to be named, and the names of these values must match the names of the original data set.}

\item{cover}{An \eqn{n \times 2} \code{matrix} of interval left and right endpoints; rows should be intervals and columns left and right endpoints (in that order).}

\item{clusterer}{A function which accepts a list of distance matrices as input, and returns the results of clustering done on each distance matrix;
that is, it should return a list of named vectors, whose name are the names of data points and whose values are cluster assignments (integers).
If this value is omitted, then trivial clustering will be done.}
}
\value{
A \code{list} of two data frames, \code{nodes} and \code{edges}, which contain information about the Mapper graph constructed from the given parameters.

The node data frame consists of:
\itemize{
\item \code{id}: vertex ID
\item \code{cluster_size}: number of data points in cluster
\item \code{medoid}: the name of the medoid of the vertex
\item \code{mean_dist_to_medoid}: mean distance to medoid of cluster
\item \code{max_dist_to_medoid}: max distance to medoid of cluster
\item \code{cluster_width}: maximum pairwise distance within cluster
\item \code{wcss}: sum of squares of distances to cluster medoid
\item \code{data}: names of data points in cluster
\item \code{patch}: level set ID
}

The \code{edge} data frame contains consists of:
\itemize{
\item \code{source}: vertex ID of edge source
\item \code{target}: vertex ID of edge target
\item \code{weight}: Jaccard index of edge; this is the size of the intersection between the vertices divided by the union
\item \code{overlap_data}: names of data points in overlap
\item \code{overlap_size}: number of data points overlap
}
}
\description{
Run Mapper using a one-dimensional filter, a cover of the codomain of intervals, and a clusterer.
}
\examples{
# Create noisy circle data
data = data.frame(x = sapply(1:1000, function(x) cos(x)) + runif(1000, 0, .25),
 y = sapply(1:1000, function(x) sin(x)) + runif(1000, 0, .25))

# Project to horizontal axis as lens
projx = data$x
names(projx) = row.names(data)

# Create a one-dimensional cover
num_bins = 5
percent_overlap = 25
cover = create_width_balanced_cover(min(projx), max(projx), num_bins, percent_overlap)

# Build Mapper object
create_1D_mapper_object(data, dist(data), projx, cover)
}
