% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fulldim.R
\name{fulldim}
\alias{fulldim}
\title{Reconstructs full dimensionality of MAgPIE objects}
\usage{
fulldim(x, sep = ".")
}
\arguments{
\item{x}{A MAgPIE-object}

\item{sep}{A character separating joined dimension names}
}
\value{
A list containing in the first element the dim output and in the
second element the dimnames output of the reconstructed array.
}
\description{
If a MAgPIE object is created from a source with more than one data
dimension, these data dimensions are combined to a single dimension. fulldim
reconstructs the original dimensionality and reports it.
}
\examples{

  a <- as.magpie(array(1:6,c(3,2),list(c("bla","blub","ble"),c("up","down"))))
  fulldim(a)


}
\seealso{
\code{\link{as.magpie}},\code{\link{unwrap}},\code{\link{wrap}}
}
\author{
Jan Philipp Dietrich
}
