% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examine-mailbox.R
\name{examine_mailbox}
\alias{examine_mailbox}
\title{Examine Mailbox}
\usage{
examine_mailbox(imapconf, retries = 2)
}
\arguments{
\item{imapconf}{An object of class \code{imapconf} generated with
\code{configure_imap} and with a \code{mbox} item added after a
mailbox selection with \code{select_mailbox}}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{2}.}
}
\value{
A \code{vector} containing the (\code{"EXISTS"}) and the
    (\code{"RECENT"}) number of messages in the selected mailbox.
}
\description{
Retrieve the number of recent messages and the total number of
    messages in a mailbox.
}
\examples{
\dontrun{

# configure IMAP
library(mRpostman)
imapconf <- configure_imap(url="imaps://your.imap.server.com",
                           username="your_username",
                           password=rstudioapi::askForPassword()
                          )

# list mailboxes
results <- imapconf \%>\%
  list_mailboxes() \%>\%
  select_mailbox(mbox = "Sent") \%>\%
  examine_mailbox()

}
}
\seealso{
Other mailbox commands: \code{\link{list_mailboxes}},
  \code{\link{list_server_capabilities}},
  \code{\link{rename_mailbox}},
  \code{\link{select_mailbox}}
}
\concept{mailbox commands}
