% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/logisticSVD.R
\name{logisticSVD}
\alias{logisticSVD}
\title{Logistic Singular Value Decomposition}
\usage{
logisticSVD(x, k = 2, quiet = TRUE, max_iters = 1000,
  conv_criteria = 1e-05, random_start = FALSE, start_A, start_B, start_mu,
  use_irlba = TRUE, main_effects = TRUE)
}
\arguments{
\item{x}{matrix with all binary entries}

\item{k}{rank of the SVD}

\item{quiet}{logical; whether the calculation should give feedback}

\item{max_iters}{number of maximum iterations}

\item{conv_criteria}{convergence criteria. The difference between average deviance
in successive iterations}

\item{random_start}{logical; whether to randomly inititalize the parameters. If \code{FALSE},
algorithm will use an SVD as starting value}

\item{start_A}{starting value for the left singular vectors}

\item{start_B}{starting value for the right singular vectors}

\item{start_mu}{starting value for mu. Only used if \code{main_effects = TRUE}}

\item{use_irlba}{logical; if \code{TRUE}, the function uses the irlba package
to more quickly calculate the SVD. When the number of columns is small,
the approximation may be less accurate}

\item{main_effects}{logical; whether to include main effects in the model}
}
\value{
An S3 object of class \code{lsvd} which is a list with the
following components:
\item{mu}{the main effects}
\item{A}{a \code{k}-dimentional orthogonal matrix with the scaled left singular vectors}
\item{B}{a \code{k}-dimentional orthonormal matrix with the right singular vectors}
\item{iters}{number of iterations required for convergence}
\item{loss_trace}{the trace of the average negative log likelihood of the algorithm.
   Should be non-increasing}
\item{prop_deviance_expl}{the proportion of deviance explained by this model.
   If \code{main_effects = TRUE}, the null model is just the main effects, otherwise
   the null model estimates 0 for all natural parameters.}
}
\description{
Dimensionality reduction for binary data by extending SVD to
minimize binomial deviance.
}
\examples{
# construct a low rank matrix in the logit scale
rows = 100
cols = 10
set.seed(1)
mat_logit = outer(rnorm(rows), rnorm(cols))

# generate a binary matrix
mat = (matrix(runif(rows * cols), rows, cols) <= inv.logit.mat(mat_logit)) * 1.0

# run logistic SVD on it
lsvd = logisticSVD(mat, k = 1, main_effects = FALSE, use_irlba = FALSE)

# Logistic SVD likely does a better job finding latent features
# than standard SVD
plot(svd(mat_logit)$u[, 1], lsvd$A[, 1])
plot(svd(mat_logit)$u[, 1], svd(mat)$u[, 1])
}
\references{
de Leeuw, Jan, 2006. Principal component analysis of binary data
by iterated singular value decomposition. Computational Statistics & Data Analysis
50 (1), 21--39.

Collins, M., Dasgupta, S., & Schapire, R. E., 2001. A generalization of principal
components analysis to the exponential family. In NIPS, 617--624.
}

