% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.lmmspline}
\alias{plot.lmmspline}
\title{Plot of \code{lmmspline} object}
\usage{
\method{plot}{lmmspline}(x, y, smooth, ...)
}
\arguments{
\item{x}{An object of class \code{lmmspline}.}

\item{y}{\code{character} or \code{numeric} value. Determining which feature should be plotted can be either the index or the name of the feature.}

\item{smooth}{an optional \code{logical} value. Default \code{FALSE}, if \code{TRUE} smooth representation of the fitted values.}

\item{\ldots}{Additional arguments which are passed to \code{plot}.}
}
\value{
xyplot showing raw data, mean profile and fitted profile.
}
\description{
Plots the raw data, the mean and the fitted or derivative information of the \code{lmmspline} object.
}
\examples{
\dontrun{
data(kidneySimTimeGroup)
# running for samples in group 1
G1 <- which(kidneySimTimeGroup$group=="G1")
testLmmspline <- lmmSpline(data=kidneySimTimeGroup$data[G1,],
                 time=kidneySimTimeGroup$time[G1],
                 sampleID=kidneySimTimeGroup$sampleID[G1])
plot(testLmmspline, y=2)
plot(testLmmspline, y=2, smooth=TRUE)}
}

