% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addTilesAmap.R
\name{addTilesAmap}
\alias{addTilesAmap}
\title{Adds a tile layer from Amap to a leaflet map.}
\usage{
addTilesAmap(
  map,
  attribution = "&copy; <a href=\\"http://amap.com\\">amap.com</a >",
  ...
)
}
\arguments{
\item{map}{A leaflet map object to which the tile layer will be added.}

\item{attribution}{A string containing the attribution text to be displayed
on the map. It defaults to "&copy; <a href=\"http://amap.com\">amap.com</a>".}

\item{...}{Additional arguments to be passed to the `leaflet::addTiles`
function.}
}
\value{
The leaflet map object with the added tile layer.
}
\description{
This function adds a tile layer from Amap to a leaflet map object.
}
\examples{
library(leaflet)
leaflet() \%>\%
  addTilesAmap() \%>\%
  setView(
    lng = 120.33739,
    lat = 31.13533,
    zoom = 3
  )

}
