% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-modelsearch2.R
\name{nStep}
\alias{nStep}
\alias{nStep.modelsearch2}
\title{Find the Number of Steps Performed During the Sequential Testing}
\usage{
nStep(object)

\method{nStep}{modelsearch2}(object)
}
\arguments{
\item{object}{a \code{modelsearch2} object.}
}
\value{
an integer.
}
\description{
Find the number of steps performed during the sequential testing.
}
\examples{
mSim <- lvm(Y~G+X1+X2)
addvar(mSim) <- ~Z1+Z2+Z3+Z4+Z5+Z6
df.data <- lava::sim(mSim, 1e2)

mBase <- lvm(Y~G)
addvar(mBase) <- ~X1+X2+Z1+Z2+Z3+Z4+Z5+Z6
e.lvm <- estimate(mBase, data = df.data)
res <- modelsearch2(e.lvm, statistic = "score", method.p.adjust = "holm")
nStep(res)

}
\concept{
modelsearch

extractor
}
