% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals2.R
\name{residuals2}
\alias{residuals2}
\alias{residuals2.lm2}
\alias{residuals2.gls2}
\alias{residuals2.lme2}
\alias{residuals2.lvmfit2}
\title{Extract Corrected Residuals}
\usage{
residuals2(object, ...)

\method{residuals2}{lm2}(object, param = NULL, data = NULL, ...)

\method{residuals2}{gls2}(object, param = NULL, data = NULL, ...)

\method{residuals2}{lme2}(object, param = NULL, data = NULL, ...)

\method{residuals2}{lvmfit2}(object, param = NULL, data = NULL, ...)
}
\arguments{
\item{object}{a \code{lm2}, \code{gls2}, \code{lme2}, or \code{lvmfit2} object.}

\item{...}{arguments to be passed to \code{sCorrect}.}

\item{param}{[optional] the fitted parameters.}

\item{data}{[optional] the data set.}
}
\value{
a matrix containing the residuals relative to each sample (in rows)
and each endogenous variable (in column).
}
\description{
Extract correct residuals from a gaussian linear model.
}
\details{
If argument \code{p} or \code{data} is not null, then the small sample size correction is recomputed to correct the residuals.
}
\examples{
## simulate data
set.seed(10)
m <- lvm(Y1~eta,Y2~eta,Y3~eta)
latent(m) <- ~eta
d <- sim(m,20, latent = FALSE)

## standard linear model
e.lm <- lm(Y1~Y2, data = d)
sCorrect(e.lm) <- TRUE

sigma(e.lm)^2
mean(residuals(e.lm)^2)
mean(residuals2(e.lm)^2)

## latent variable model
e.lvm <- estimate(m, data = d)
sCorrect(e.lvm) <- TRUE
mean(residuals2(e.lvm)^2)

}
\seealso{
\code{\link{sCorrect}} to obtain \code{lm2}, \code{gls2}, \code{lme2}, or \code{lvmfit2} objects.
}
\concept{
small sample inference
}
