% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils-nlme.R
\name{coef2-internal}
\alias{coef2-internal}
\alias{.coef2}
\alias{.coef2.lm}
\alias{.coef2.gls}
\alias{.coef2.lme}
\title{Export Mean and Variance Coefficients}
\usage{
.coef2(object)

\method{.coef2}{lm}(object)

\method{.coef2}{gls}(object)

\method{.coef2}{lme}(object)
}
\arguments{
\item{object}{a \code{lm}, \code{gls} or \code{lme} object.}

\item{name.Y}{[character] the name of the endogenous variable. Used to name certain variance parameters.}
}
\value{
A numeric vector named with the names of the coefficient with three attributes:
\itemize{
\item mean.coef: the name of the mean coefficients.
\item var.coef: the name of the variance coefficients.
\item cor.coef:  the name of the correlation coefficients.
}
}
\description{
Export mean and variance coefficients
from a \code{lm}, \code{gls}, or \code{lme} object.
}
\details{
The variance coefficients that are exported are the residual variance of each outcome. 
This is \eqn{\sigma^2} for the first one and \eqn{k^2 \sigma^2} for the remaining ones.
}
\concept{
extractor
}
\keyword{internal}
