% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals2.R
\name{residuals2}
\alias{residuals2}
\alias{residuals2.lm}
\alias{residuals2.gls}
\alias{residuals2.lme}
\alias{residuals2.lvmfit}
\title{Compute the Residuals from a lvmfit Object}
\usage{
residuals2(object, ...)

\method{residuals2}{lm}(object, adjust.residuals = TRUE,
  return.vcov.param = FALSE, ...)

\method{residuals2}{gls}(object, cluster = NULL, p = NULL, data = NULL,
  adjust.residuals = TRUE, as.clubSandwich = TRUE, second.order = FALSE,
  return.vcov.param = FALSE, return.prepareScore2 = FALSE, ...)

\method{residuals2}{lme}(object, cluster = NULL, p = NULL, data = NULL,
  adjust.residuals = TRUE, as.clubSandwich = TRUE, second.order = FALSE,
  return.vcov.param = FALSE, return.prepareScore2 = FALSE, ...)

\method{residuals2}{lvmfit}(object, p = NULL, data = NULL,
  adjust.residuals = TRUE, as.clubSandwich = TRUE, second.order = FALSE,
  return.vcov.param = FALSE, return.prepareScore2 = FALSE, ...)
}
\arguments{
\item{object}{a fitted latent variable model.}

\item{...}{[internal] Only used by the generic method.}

\item{adjust.residuals}{Small sample correction: should the leverage-adjusted residuals be used to compute the score? Otherwise the raw residuals will be used.}

\item{return.vcov.param}{Should the variance covariance matrix of the parameters be included in the output?}

\item{cluster}{[only required for gls objects] a vector indicating the clusters of observation that are iid.}

\item{p}{[optional] vector of parameters at which to evaluate the score.}

\item{data}{[optional] data set.}

\item{as.clubSandwich}{method to take the square root of a non symmetric matrix. If \code{TRUE} use a method implemented in the \code{clubSandwich} package.}

\item{second.order}{should the terms relative to the third derivative of the likelihood be be pre-computed?}

\item{return.prepareScore2}{should the quantities that have been pre-computed be returned?}
}
\description{
Compute the residuals from a lvmfit object.
}
\examples{
m <- lvm(Y1~eta,Y2~eta,Y3~eta)
latent(m) <- ~eta

e <- estimate(m,sim(m,1e2))
residuals2(e)
}
