% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcType1postSelection.R
\name{calcType1postSelection}
\alias{calcType1postSelection}
\title{Compute the Type 1 Error After Selection}
\usage{
calcType1postSelection(level, mu, Sigma, quantile.previous, distribution, df,
  n = 10, correct = TRUE, ...)
}
\arguments{
\item{level}{expected coverage.}

\item{mu}{vector of means for the joint distribution of the test statistics}

\item{Sigma}{variance-covariance matrix for the joint distribution of the test statistics.}

\item{quantile.previous}{significance quantile used at the previous step.}

\item{distribution}{distribution of the test statistics.
Can be \code{"pmvnorm"} (normal distribution) or \code{"pvmt"} (student's t distribution)}

\item{df}{degree of freedoms (only used for the student distribution).}

\item{n}{number of points for the numerical integration}

\item{correct}{logical. If true, returns the corrected level that should be used
to obtain the expected coverage.}

\item{...}{arguments passed to lower level functions}
}
\value{
type 1 error (numeric)
}
\description{
Compute the type 1 error after selection.
}
\details{
The number of tests at the current step (i.e. after selection) is assumed to be
one less than the number of tests at the previous step (i.e. before selection).

Arguments \code{mu} and \code{Sigma} must contain the moments for the vector of test statistics
after and before selection.
}
\examples{
library(mvtnorm)
n <- 350

#### only 2 tests
Sigma <- rbind(c(1,0,0),c(0,1,1),c(0,1,1))
z2 <- qmvnorm(0.95, mean = rep(0,2), sigma = Sigma[1:2,1:2], tail = "both.tails")$quantile

## no selection since strong effect
mu <- c(10,0,0)
calcType1postSelection(0.95, quantile.previous = z2, distribution = "gaussian",
                        mu = mu, Sigma = Sigma, correct = TRUE)

## strong selection
\dontrun{
mu <- c(0,0,0)
levelC <- calcType1postSelection(0.95, quantile.previous = z2, distribution = "gaussian",
                        mu = mu, Sigma = Sigma)
print(levelC) # more liberal than without selection
calcType1postSelection(levelC, quantile.previous = z2, distribution = "gaussian",
                        mu = mu, Sigma = Sigma, correct = FALSE)
}

#### 3 tests
Sigma <- diag(1,5,5)
Sigma[4,2] <- 1
Sigma[2,4] <- 1
Sigma[5,3] <- 1
Sigma[3,5] <- 1

z2 <- qmvnorm(0.95, mean = mu[1:3], sigma = Sigma[1:3,1:3], tails = "both.tails")$quantile

## no selection since strong effect
\dontrun{
mu <- c(10,0,0,0,0)
calcType1postSelection(0.95, quantile.previous = z2, distribution = "gaussian",
                        mu = mu, Sigma = Sigma, correct = TRUE)

## strong selection
mu <- c(0,0,0,0,0)
levelC <- calcType1postSelection(0.95, quantile.previous = z2,
                        mu = mu, Sigma = Sigma, distribution = "gaussian")
calcType1postSelection(levelC, quantile.previous = z2, distribution = "gaussian",
                        mu = mu, Sigma = Sigma, correct = FALSE)
}

}
\author{
Brice Ozenne
}
