% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regex_match.R
\name{regex_match}
\alias{regex_match}
\title{Regular expression matches}
\usage{
regex_match(regex = NULL, vector = NULL, silent = FALSE, perl = FALSE)
}
\arguments{
\item{regex}{a regular expression
provided, a default theme will be used.}

\item{vector}{a character vector in which to search for regular
expression matches, or a data table whose column names will be searched}

\item{silent}{logical. If \code{silent = FALSE}, a report on regular
expression matches will be printed. If \code{silent = TRUE}, the report
on regular expression matches will not be printed.
By default, \code{silent = FALSE}}

\item{perl}{logical. Should Perl-compatible regexps be used?}
}
\description{
Returns elements of a character vector that match the given
regular expression
}
\examples{
regex_match("p$", names(mtcars))
\donttest{
colnames_ending_with_p <- regex_match("p$", names(mtcars))
}
}
