% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_gamma.R
\name{update_Gamma}
\alias{update_Gamma}
\title{update_Gamma}
\usage{
update_Gamma(conj.param, ft, Qt, y, parms)
}
\arguments{
\item{conj.param}{list: A vector containing the parameters of the Inverse-Gamma (alpha,beta).}

\item{ft}{numeric: A vector representing the means from the normal distribution. Not used in the default method.}

\item{Qt}{matrix: A matrix representing the covariance matrix of the normal distribution. Not used in the default method.}

\item{y}{numeric: A vector containing the observations.}

\item{parms}{list: A list of extra known parameters of the distribution. For this kernel, parms should containing the shape parameter (phi) for the observational gamma model.}
}
\value{
The parameters of the posterior distribution.
}
\description{
Calculate posterior parameter for the Inverse-Gamma, assuming that the observed values came from a Gamma model from which the shape parameter (phi) is known and the mean (mu) have prior distribution Inverse-Gamma.
}
\seealso{
Other auxiliary functions for a Gamma outcome with known shape: 
\code{\link{convert_Gamma_Normal}()},
\code{\link{convert_Normal_Gamma}()},
\code{\link{gamma_pred}()}
}
\concept{auxiliary functions for a Gamma outcome with known shape}
\keyword{internal}
