% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_helper.R
\name{intervention}
\alias{intervention}
\title{An auxiliary function for model intervention}
\usage{
intervention(
  block,
  time,
  var.index = 1:block$n,
  FF = NULL,
  D = NULL,
  h = NULL,
  H = NULL,
  G = NULL
)
}
\arguments{
\item{block}{dlm_block: The block to add the intervention.}

\item{time}{Vector: A sequence of integers indicating the time of the intervention.}

\item{var.index}{Vector: A sequence of integers indicating which variables should be modified in the intervention.}

\item{FF}{Array: A n x k x t array with the modified FF to be used during the intervention, where n is the length of var.index, k is the number of linear predictors in the block and t is the size of time (can be omitted if time is a scalar).}

\item{D}{Array: A n x n x t array with the modified D to be used during the intervention, where n is the length of var.index and t is the size of time (can be omitted if time is a scalar).}

\item{h}{matrix: A n x t matrix with the modified h to be used during the intervention, where n is the length of var.index and t is the size of time (can be omitted if time is a scalar).}

\item{H}{Array: A n x n x t array with the modified H to be used during the intervention, where n is the length of var.index and t is the size of time (can be omitted if time is a scalar).}

\item{G}{Array: A n x n x t array with the modified G to be used during the intervention, where n is the length of var.index and t is the size of time (can be omitted if time is a scalar).}
}
\value{
A dlm_block with the added intervention.
}
\description{
This function adds timely modifications to a dlm_block, such that in the specified time the model will override the usual value of the each variable to the value chosen by the user.
}
\examples{

data <- c(AirPassengers)
# Adding an artificial change, so that we can make an intervention on the data at that point
# Obviously, one should NOT change their own data.
data[60:144] <- data[60:144] + 500

level <- polynomial_block(rate = 1, order = 2, D = 0.95)
season <- harmonic_block(rate = 1, order = 2, period = 12, D = 0.975)

# Reducing the discount factor so that the model can capture the expected change.
level <- level |> intervention(time = 60, H = 1, var.index = 1)
# Comment the line above to see the fit without the intervention

outcome <- Poisson(lambda = "rate", data = data)

fitted.data <- fit_model(level, season,
  AirPassengers = outcome
)

plot(fitted.data, plot.pkg = "base")

}
\seealso{
Other auxiliary functions for structural blocks: 
\code{\link{TF_block}()},
\code{\link{block_mult}()},
\code{\link{block_rename}()},
\code{\link{block_superpos}()},
\code{\link{ffs_block}()},
\code{\link{harmonic_block}()},
\code{\link{noise_block}()},
\code{\link{polynomial_block}()},
\code{\link{regression_block}()},
\code{\link{specify.dlm_block}()},
\code{\link{summary.dlm_block}()}
}
\concept{auxiliary functions for structural blocks}
