% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmrm_rbmi.R
\name{rbmi_mmrm_single_info}
\alias{rbmi_mmrm_single_info}
\title{Extract Single Visit Information from a Fitted MMRM for Multiple Imputation Analysis}
\usage{
rbmi_mmrm_single_info(fit, visit_level, visit, group, weights)
}
\arguments{
\item{fit}{(\code{mmrm})\cr the fitted MMRM.}

\item{visit_level}{(\code{string})\cr the visit level to extract information for.}

\item{visit}{(\code{string})\cr the name of the visit variable.}

\item{group}{(\code{string})\cr the name of the group variable.}

\item{weights}{(\code{string})\cr the weighting strategy to be used when calculating the
least square means, either \code{'counterfactual'} or \code{'equal'}.}
}
\value{
a list with \verb{trt_*}, \verb{var_*} and \verb{lsm_*} elements. See \link{rbmi_mmrm} for
full details.
}
\description{
Extracts relevant estimates from a given fitted MMRM. See \code{\link[=rbmi_mmrm]{rbmi_mmrm()}} for full details.
}
\seealso{
\code{\link[=rbmi_mmrm]{rbmi_mmrm()}}
}
