% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{jenkins}
\alias{jenkins}
\title{Jenkins Client}
\usage{
jenkins(server = "http://jenkins.ropensci.org", username = "jeroen",
  token = jenkins_pat(), verbose = FALSE)
}
\arguments{
\item{server}{base url of the jenkins server}

\item{username}{name of the jenkins user to login}

\item{token}{authentication token (or password) for your jenkins server.}

\item{verbose}{print http output for debugging}
}
\description{
Simple client for managing jobs and builds on a Jenkins server. Set a
default access token via the \code{JENKINS_PAT} environment variable.
}
\section{Methods}{

\Sexpr[results=rd, stage=build, echo=FALSE]{jenkins:::generate_rd()}
}

\examples{
\donttest{# Make a connection
jk <- jenkins(server = 'http://jenkins.ropensci.org', username = 'jeroen')

# Do stuff
jk$server_info()
jk$project_build('magick')

# It's now in the queue
jk$queue_list()

# Check build status
jk$build_info('magick')

# Get latest build log
jk$build_log('magick', build_id = 'lastCompletedBuild')
}
}
\references{
\url{https://wiki.jenkins.io/display/JENKINS/Terminology}
}
