% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{james}
\alias{james}
\title{Results of example algorithm comparison}
\format{S3 object of class "james", as if produced by
  \code{\link{readJAMES}}.}
\source{
\url{http://www.jamesframework.org/examples/#analysis}
}
\usage{
james
}
\description{
Contains results of an example analysis performed with the `JAMES' extensions
module. The performance of two algorithms is compared (random descent and
parallel tempering) for a core selection problem in which the mean
entry-to-nearest-entry distance is maximized. Four different data sets have
been analyzed. Details about the performed analysis are provided at the
website (see below).
}
\examples{
# load data
data(james)
summary(james)

# plot convergence curves for coconut data set
plotConvergence(james, problem = "coconut", min.time = 1000, max.time = 100000)

# create box plots of solution values (quality) and convergence times
boxplot(james, problem = "coconut")
boxplot(james, problem = "coconut", type = "time")

# extract solution values and convergence times for parallel tempering and random descent
values.pt <- getBestSolutionValues(james, problem = "coconut", search = "Parallel Tempering")
times.pt <- getConvergenceTimes(james, problem = "coconut", search = "Parallel Tempering")
values.rd <- getBestSolutionValues(james, problem = "coconut", search = "Random Descent")
times.rd <- getConvergenceTimes(james, problem = "coconut", search = "Random Descent")

# perform wilcoxon test to compare distributions across algorithms
values.test <- wilcox.test(values.pt, values.rd)
values.test
times.test <- wilcox.test(times.pt, times.rd)
times.test

# adjust p-values for multiple testing
p.adjust(c(values.test$p.value, times.test$p.value))
}
\seealso{
\code{\link{readJAMES}}
}
\keyword{datasets}

