% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_model-building.R
\name{set_steady}
\alias{set_steady}
\title{Flag some network compartments as being in a steady state}
\usage{
set_steady(nm, comps = NULL, which = NULL)
}
\arguments{
\item{nm}{A \code{networkModel} object.}

\item{comps}{Vector of strings, names of the compartments to set steady.}

\item{which}{Vector of integers giving the nm rows to update. Default is to
update all rows.}
}
\value{
A \code{networkModel} object.
}
\description{
Flag some network compartments as being in a steady state
}
\examples{
library(magrittr)
x <- new_networkModel() \%>\%
   set_topo("NH4 -> algae -> daphnia") \%>\%
   set_steady("NH4")
topo(x)

}
